package ru.yandex.client.cocaine.worker.http;

import java.util.List;
import java.util.concurrent.Executor;

import cocaine.hpack.HeaderField;
import org.apache.http.HttpRequest;

import ru.yandex.client.cocaine.worker.CocaineWorkerSession;

public class CocaineExecutorHttpRequestHandler
    implements CocaineHttpRequestHandler
{
    private final Executor executor;
    private final CocaineHttpRequestHandler handler;

    public CocaineExecutorHttpRequestHandler(
        final Executor executor,
        final CocaineHttpRequestHandler handler)
    {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final List<HeaderField> headers,
        final CocaineWorkerSession session)
    {
        executor.execute(() -> handler.handle(request, headers, session));
    }
}

