package ru.yandex.client.cocaine.worker.http;

import ru.yandex.client.cocaine.worker.CocaineWorkerServiceConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface CocaineHttpServiceConfig extends CocaineWorkerServiceConfig {
    ParameterConfig<Integer> WORKERS = new ParameterConfig<>(
        "workers",
        x -> Integer.valueOf(x),
        PositiveValidator.instance());
    ParameterConfig<Integer> REQUESTS_QUEUE_SIZE = new ParameterConfig<>(
        "requests-queue-size",
        x -> Integer.valueOf(x),
        PositiveValidator.instance());
    ParameterConfig<Long> MIN_REQUEST_TIME = new ParameterConfig<>(
        "min-request-time",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());
    ParameterConfig<Long> GRACEFUL_SHUTDOWN_TIMEOUT = new ParameterConfig<>(
        "graceful-shutdown-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());

    int workers();

    int requestsQueueSize();

    long minRequestTime();

    long gracefulShutdownTimeout();
}

