package ru.yandex.client.cocaine.worker.http;

import java.util.function.Function;

import ru.yandex.client.cocaine.CocaineServiceException;
import ru.yandex.http.util.BadGatewayException;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ForbiddenException;
import ru.yandex.http.util.LockedException;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.ServerException;

public enum CocaineServiceExceptionConverter
    implements Function<CocaineServiceException, ServerException>
{
    INSTANCE;

    @Override
    public ServerException apply(final CocaineServiceException e) {
        if (e.category() == CocaineServiceException.Category.UNISTORAGE) {
            int code = e.code();
            if (code
                == CocaineServiceException.UnistorageCode.INVALID_INPUT_DATA)
            {
                return new BadRequestException(e);
            } else if (code
                == CocaineServiceException.UnistorageCode.FILE_NOT_FOUND)
            {
                return new NotFoundException();
            } else if (code
                == CocaineServiceException.UnistorageCode.GENERIC_ACL_ERROR)
            {
                return new LockedException(e);
            } else if (code
                >= CocaineServiceException.UnistorageCode.GENERIC_AUTH_ERROR)
            {
                return new ForbiddenException(e);
            }
        }
        return new BadGatewayException(e);
    }
}

