package ru.yandex.client.cocaine.worker.http;

import ru.yandex.client.cocaine.worker.ImmutableCocaineWorkerServiceConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableCocaineHttpServiceConfig
    extends ImmutableCocaineWorkerServiceConfig
    implements CocaineHttpServiceConfig
{
    private final int workers;
    private final int requestsQueueSize;
    private final long minRequestTime;
    private final long gracefulShutdownTimeout;

    public ImmutableCocaineHttpServiceConfig(
        final CocaineHttpServiceConfig config)
        throws ConfigException
    {
        super(config);
        workers = WORKERS.validate(config.workers());
        requestsQueueSize =
            REQUESTS_QUEUE_SIZE.validate(config.requestsQueueSize());
        minRequestTime = MIN_REQUEST_TIME.validate(config.minRequestTime());
        gracefulShutdownTimeout = GRACEFUL_SHUTDOWN_TIMEOUT.validate(
            config.gracefulShutdownTimeout());
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public int requestsQueueSize() {
        return requestsQueueSize;
    }

    @Override
    public long minRequestTime() {
        return minRequestTime;
    }

    @Override
    public long gracefulShutdownTimeout() {
        return gracefulShutdownTimeout;
    }
}

