package ru.yandex.client.cocaine.worker.http.unistorage;

import ru.yandex.client.cocaine.CocaineServiceConfig;
import ru.yandex.client.cocaine.CocaineServiceConfigBuilder;
import ru.yandex.client.cocaine.unistorage.UnistorageServiceConfig;
import ru.yandex.client.cocaine.unistorage.UnistorageServiceConfigBuilder;
import ru.yandex.client.cocaine.worker.http.AbstractCocaineHttpServiceConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUnistorageHttpServiceConfigBuilder
    <T extends AbstractUnistorageHttpServiceConfigBuilder<T>>
    extends AbstractCocaineHttpServiceConfigBuilder<T>
    implements UnistorageHttpServiceConfig
{
    private CocaineServiceConfigBuilder locatorConfig;
    private CocaineServiceConfigBuilder loggingConfig;
    private UnistorageServiceConfigBuilder unistorageConfig;

    protected AbstractUnistorageHttpServiceConfigBuilder(
        final UnistorageHttpServiceConfig config)
    {
        super(config);
        locatorConfig(config.locatorConfig());
        loggingConfig(config.loggingConfig());
        unistorageConfig(config.unistorageConfig());
    }

    protected AbstractUnistorageHttpServiceConfigBuilder(
        final IniConfig config,
        final UnistorageHttpServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        locatorConfig = new CocaineServiceConfigBuilder(
            config.section("locator"),
            defaults.locatorConfig());
        loggingConfig = new CocaineServiceConfigBuilder(
            config.section("logging"),
            defaults.loggingConfig());
        unistorageConfig = new UnistorageServiceConfigBuilder(
            config.section("unistorage"),
            defaults.unistorageConfig());
    }

    @Override
    public CocaineServiceConfigBuilder locatorConfig() {
        return locatorConfig;
    }

    public T locatorConfig(final CocaineServiceConfig locatorConfig) {
        this.locatorConfig = new CocaineServiceConfigBuilder(locatorConfig);
        return self();
    }

    @Override
    public CocaineServiceConfigBuilder loggingConfig() {
        return loggingConfig;
    }

    public T loggingConfig(final CocaineServiceConfig loggingConfig) {
        this.loggingConfig = new CocaineServiceConfigBuilder(loggingConfig);
        return self();
    }

    @Override
    public UnistorageServiceConfigBuilder unistorageConfig() {
        return unistorageConfig;
    }

    public T unistorageConfig(final UnistorageServiceConfig unistorageConfig) {
        this.unistorageConfig =
            new UnistorageServiceConfigBuilder(unistorageConfig);
        return self();
    }
}

