package ru.yandex.client.cocaine.worker.http.unistorage;

import ru.yandex.client.cocaine.ImmutableCocaineServiceConfig;
import ru.yandex.client.cocaine.unistorage.ImmutableUnistorageServiceConfig;
import ru.yandex.client.cocaine.worker.http.ImmutableCocaineHttpServiceConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableUnistorageHttpServiceConfig
    extends ImmutableCocaineHttpServiceConfig
    implements UnistorageHttpServiceConfig
{
    private final ImmutableCocaineServiceConfig locatorConfig;
    private final ImmutableCocaineServiceConfig loggingConfig;
    private final ImmutableUnistorageServiceConfig unistorageConfig;

    public ImmutableUnistorageHttpServiceConfig(
        final UnistorageHttpServiceConfig config)
        throws ConfigException
    {
        super(config);
        locatorConfig =
            new ImmutableCocaineServiceConfig(config.locatorConfig());
        loggingConfig =
            new ImmutableCocaineServiceConfig(config.loggingConfig());
        unistorageConfig =
            new ImmutableUnistorageServiceConfig(config.unistorageConfig());
    }

    @Override
    public ImmutableCocaineServiceConfig locatorConfig() {
        return locatorConfig;
    }

    @Override
    public ImmutableCocaineServiceConfig loggingConfig() {
        return loggingConfig;
    }

    @Override
    public ImmutableUnistorageServiceConfig unistorageConfig() {
        return unistorageConfig;
    }
}

