package ru.yandex.client.cocaine.worker;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCocaineWorkerServiceConfigBuilder
    <T extends AbstractCocaineWorkerServiceConfigBuilder<T>>
    implements CocaineWorkerServiceConfig
{
    private long readTimeout;
    private long heartbeatInterval;
    private long heartbeatExecutionTimeout;
    private long heartbeatReplyTimeout;
    private int queueSize;

    protected AbstractCocaineWorkerServiceConfigBuilder(
        final CocaineWorkerServiceConfig config)
    {
        readTimeout(config.readTimeout());
        heartbeatInterval(config.heartbeatInterval());
        heartbeatExecutionTimeout(config.heartbeatExecutionTimeout());
        heartbeatReplyTimeout(config.heartbeatReplyTimeout());
        queueSize(config.queueSize());
    }

    protected AbstractCocaineWorkerServiceConfigBuilder(
        final IniConfig config,
        final CocaineWorkerServiceConfig defaults)
        throws ConfigException
    {
        readTimeout(READ_TIMEOUT.extract(config, defaults.readTimeout()));
        heartbeatInterval(
            HEARTBEAT_INTERVAL.extract(config, defaults.heartbeatInterval()));
        heartbeatExecutionTimeout(
            HEARTBEAT_EXECUTION_TIMEOUT.extract(
                config,
                defaults.heartbeatExecutionTimeout()));
        heartbeatReplyTimeout(
            HEARTBEAT_REPLY_TIMEOUT.extract(
                config,
                defaults.heartbeatReplyTimeout()));
        queueSize(QUEUE_SIZE.extract(config, defaults.queueSize()));
    }

    protected abstract T self();

    @Override
    public long readTimeout() {
        return readTimeout;
    }

    public T readTimeout(final long readTimeout) {
        this.readTimeout = readTimeout;
        return self();
    }

    @Override
    public long heartbeatInterval() {
        return heartbeatInterval;
    }

    public T heartbeatInterval(final long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return self();
    }

    @Override
    public long heartbeatExecutionTimeout() {
        return heartbeatExecutionTimeout;
    }

    public T heartbeatExecutionTimeout(final long heartbeatExecutionTimeout) {
        this.heartbeatExecutionTimeout = heartbeatExecutionTimeout;
        return self();
    }

    @Override
    public long heartbeatReplyTimeout() {
        return heartbeatReplyTimeout;
    }

    public T heartbeatReplyTimeout(final long heartbeatReplyTimeout) {
        this.heartbeatReplyTimeout = heartbeatReplyTimeout;
        return self();
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    public T queueSize(final int queueSize) {
        this.queueSize = queueSize;
        return self();
    }
}

