package ru.yandex.client.cocaine.worker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cocaine.hpack.HeaderField;

public class CocaineMapEventHandlerRegistry
    implements CocaineEventHandlerRegistry
{
    private final Map<String, CocaineEventHandler> map = new HashMap<>();

    public CocaineEventHandler register(
        final String eventName,
        final CocaineEventHandler handler)
    {
        return map.put(eventName, handler);
    }

    @Override
    public CocaineEventHandler lookup(
        final String eventName,
        final List<HeaderField> headers)
    {
        return map.get(eventName);
    }
}

