package ru.yandex.client.cocaine.worker;

import java.net.InetSocketAddress;

import ru.yandex.parser.config.ConfigException;

public class CocaineWorkerConfig {
    private final String appName;
    private final String uuid;
    private final String workerEndpoint;
    private final InetSocketAddress locatorEndpoint;

    public CocaineWorkerConfig(final String... args)
        throws ConfigException
    {
        String appName = null;
        String uuid = null;
        String workerEndpoint = null;
        String locatorEndpoint = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.length() > 2
                && arg.charAt(0) == '-'
                && arg.charAt(1) == '-')
            {
                String value = args[++i];
                switch (arg) {
                    case "--app":
                        appName = value;
                        break;
                    case "--uuid":
                        uuid = value;
                        break;
                    case "--endpoint":
                        workerEndpoint = value;
                        break;
                    case "--locator":
                        locatorEndpoint = value;
                        break;
                    default:
                        break;
                }
            }
        }
        this.appName = nonNull(appName, "app");
        this.uuid = nonNull(uuid, "uuid");
        this.workerEndpoint = nonNull(workerEndpoint, "endpoint");
        String address = nonNull(locatorEndpoint, "locator").split(",")[0];
        int idx = address.lastIndexOf(':');
        if (idx == -1) {
            throw new ConfigException("No port specified in --locator");
        }
        try {
            this.locatorEndpoint = new InetSocketAddress(
                address.substring(0, idx),
                Integer.parseInt(address.substring(idx + 1)));
        } catch (RuntimeException e) {
            throw new ConfigException("Malformed --locator", e);
        }
    }

    private static String nonNull(final String value, final String name)
        throws ConfigException
    {
        if (value == null) {
            throw new ConfigException("--" + name + " is not specified");
        }
        return value;
    }

    public String appName() {
        return appName;
    }

    public String uuid() {
        return uuid;
    }

    public String workerEndpoint() {
        return workerEndpoint;
    }

    public InetSocketAddress locatorEndpoint() {
        return locatorEndpoint;
    }
}

