package ru.yandex.client.cocaine.worker;

import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.PositiveValidator;

public interface CocaineWorkerServiceConfig {
    ParameterConfig<Long> READ_TIMEOUT = new ParameterConfig<>(
        "read-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Long> HEARTBEAT_INTERVAL = new ParameterConfig<>(
        "heartbeat-interval",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Long> HEARTBEAT_EXECUTION_TIMEOUT = new ParameterConfig<>(
        "heartbeat-execution-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Long> HEARTBEAT_REPLY_TIMEOUT = new ParameterConfig<>(
        "heartbeat-reply-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Integer> QUEUE_SIZE =
        new ParameterConfig<>("queue-size", Integer::valueOf, x -> x);

    long readTimeout();

    long heartbeatInterval();

    long heartbeatExecutionTimeout();

    long heartbeatReplyTimeout();

    int queueSize();
}

