package ru.yandex.client.cocaine.worker;

import ru.yandex.parser.config.ConfigException;

public class ImmutableCocaineWorkerServiceConfig
    implements CocaineWorkerServiceConfig
{
    private final long readTimeout;
    private final long heartbeatInterval;
    private final long heartbeatExecutionTimeout;
    private final long heartbeatReplyTimeout;
    private final int queueSize;

    public ImmutableCocaineWorkerServiceConfig(
        final CocaineWorkerServiceConfig config)
        throws ConfigException
    {
        readTimeout = READ_TIMEOUT.validate(config.readTimeout());
        heartbeatInterval =
            HEARTBEAT_INTERVAL.validate(config.heartbeatInterval());
        heartbeatExecutionTimeout =
            HEARTBEAT_EXECUTION_TIMEOUT.validate(
                config.heartbeatExecutionTimeout());
        heartbeatReplyTimeout =
            HEARTBEAT_REPLY_TIMEOUT.validate(config.heartbeatReplyTimeout());
        queueSize = QUEUE_SIZE.validate(config.queueSize());
    }

    @Override
    public long readTimeout() {
        return readTimeout;
    }

    @Override
    public long heartbeatInterval() {
        return heartbeatInterval;
    }

    @Override
    public long heartbeatExecutionTimeout() {
        return heartbeatExecutionTimeout;
    }

    @Override
    public long heartbeatReplyTimeout() {
        return heartbeatReplyTimeout;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }
}

