#!/bin/sh
set -e
export ROOT=${ROOT:-/app}
source $ROOT/classpath.sh

ulimit -c unlimited

cd $ROOT
$ROOT/jdk/bin/java -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Xconcurrentbackground2 -Xconcurrentlevel8 -Xgcthreads4 -Xgcpolicy:balanced -Xmaxf0.4 -Xminf0.2 -Xmint0.03 -Xms64M -Xmx256M -Xdump:none -Xdump:java+console:events=user -Djava.library.path=$ROOT:$ROOT/iexlib_srw:$ROOT/cokemulator_srw -DROOT=$ROOT -cp $CLASSPATH ru.yandex.cokemulator.srw.CokemulatorSrw $ROOT/iexlib_srw.conf $@ 2>&1 | tee $ROOT/stdout.log