#!/bin/bash
export ROOT=${ROOT:-/app}
source $ROOT/classpath.sh

export MKL_DOMAIN_NUM_THREADS="MKL_DOMAIN_ALL=1; MKL_DOMAIN_BLAS=1; MKL_DOMAIN_FFT=1"
export MKL_DYNAMIC=FALSE
export MKL_NUM_THREADS=1
export OMP_DYNAMIC=FALSE
export OMP_NUM_THREADS=1
export OMP_SCHEDULE="static,1"

cd $ROOT
$ROOT/jdk/bin/java -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Xnoclassgc -Xconcurrentbackground2 -Xconcurrentlevel8 -Xgcthreads4 -Xgcpolicy:balanced -Xmaxf0.4 -Xminf0.2 -Xmint0.03 -Xms64M -Xmx256M -Xmso8M -Xdump:none -Xdump:java+console:events=user -Djava.library.path=$ROOT/cokemulator_srw -cp $CLASSPATH ru.yandex.cokemulator.srw.CokemulatorSrw $ROOT/ocraas-srw.conf $@ 2>&1 | tee $ROOT/stdout.log

