package ru.yandex.tikaite.srw;

import ru.yandex.client.cocaine.worker.http.unistorage.AbstractUnistorageHttpServiceConfigBuilder;
import ru.yandex.mail.so.factors.config.ExtractModulesConfig;
import ru.yandex.mail.so.factors.config.ExtractModulesConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.tikaite.config.TextExtractorConfig;
import ru.yandex.tikaite.config.TextExtractorConfigBuilder;

public abstract class AbstractTikaiteSrwConfigBuilder
    <T extends AbstractTikaiteSrwConfigBuilder<T>>
    extends AbstractUnistorageHttpServiceConfigBuilder<T>
    implements TikaiteSrwConfig
{
    private TextExtractorConfigBuilder textExtractorConfig;
    private ExtractModulesConfigBuilder extractModulesConfig;
    private String rsaPublicKey;

    protected AbstractTikaiteSrwConfigBuilder(final TikaiteSrwConfig config) {
        super(config);
        textExtractorConfig(config.textExtractorConfig());
        extractModulesConfig(config.extractModulesConfig());
        rsaPublicKey(config.rsaPublicKey());
    }

    protected AbstractTikaiteSrwConfigBuilder(
        final IniConfig config,
        final TikaiteSrwConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        textExtractorConfig = new TextExtractorConfigBuilder(
            config.section("extractor"),
            defaults.textExtractorConfig());
        IniConfig extractModuleSection =
            config.sectionOrNull("extract-modules");
        if (extractModuleSection == null) {
            extractModulesConfig = null;
        } else {
            ExtractModulesConfig extractModuleDefaults =
                defaults.extractModulesConfig();
            if (extractModuleDefaults == null) {
                extractModulesConfig =
                    new ExtractModulesConfigBuilder(extractModuleSection);
            } else {
                extractModulesConfig = new ExtractModulesConfigBuilder(
                    extractModuleSection,
                    extractModuleDefaults);
            }
        }
        rsaPublicKey = RSA_PUBLIC_KEY.extract(config, defaults.rsaPublicKey());
    }

    @Override
    public TextExtractorConfigBuilder textExtractorConfig() {
        return textExtractorConfig;
    }

    public T textExtractorConfig(
        final TextExtractorConfig textExtractorConfig)
    {
        this.textExtractorConfig =
            new TextExtractorConfigBuilder(textExtractorConfig);
        return self();
    }

    @Override
    public ExtractModulesConfigBuilder extractModulesConfig() {
        return extractModulesConfig;
    }

    public T extractModulesConfig(
        final ExtractModulesConfig extractModulesConfig)
    {
        if (extractModulesConfig == null) {
            this.extractModulesConfig = null;
        } else {
            this.extractModulesConfig =
                new ExtractModulesConfigBuilder(extractModulesConfig);
        }
        return self();
    }

    @Override
    public String rsaPublicKey() {
        return rsaPublicKey;
    }

    public T rsaPublicKey(final String rsaPublicKey) {
        this.rsaPublicKey = rsaPublicKey;
        return self();
    }
}

