package ru.yandex.tikaite.srw;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

import org.apache.http.concurrent.Cancellable;
import org.apache.http.protocol.HttpContext;

import ru.yandex.concurrent.SameThreadExecutor;
import ru.yandex.http.util.SynchronizedHttpContext;
import ru.yandex.http.util.nio.client.EmptyRequestsListener;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.parser.mail.errors.ErrorInfo;

public class CocaineSoFactorsExtractorContext
    implements SoFactorsExtractorContext
{
    private final HttpContext httpContext = new SynchronizedHttpContext();
    private final PrefixedLogger logger;
    private final FactorsAccessViolationHandler accessViolationHandler;
    private final Consumer<ErrorInfo> errorsConsumer;

    public CocaineSoFactorsExtractorContext(
        final PrefixedLogger logger,
        final FactorsAccessViolationHandler accessViolationHandler,
        final Consumer<ErrorInfo> errorsConsumer)
    {
        this.logger = logger;
        this.accessViolationHandler = accessViolationHandler;
        this.errorsConsumer = errorsConsumer;
    }

    @Override
    public FactorsAccessViolationHandler accessViolationHandler() {
        return accessViolationHandler;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public HttpContext httpContext() {
        return httpContext;
    }

    @Override
    public RequestsListener requestsListener() {
        return EmptyRequestsListener.INSTANCE;
    }

    @Override
    public Consumer<ErrorInfo> errorsConsumer() {
        return errorsConsumer;
    }

    @Override
    public Executor executor() {
        return SameThreadExecutor.INSTANCE;
    }

    @Override
    public boolean debugExtractors() {
        return false;
    }

    @Override
    public Set<String> debugFlags() {
        return Collections.emptySet();
    }

    // CancellationSubscriber implementation
    @Override
    public boolean cancelled() {
        return false;
    }

    @Override
    public void subscribeForCancellation(final Cancellable callback) {
    }

    @Override
    public void unsubscribeFromCancellation(final Cancellable callback) {
    }
}

