package ru.yandex.tikaite.srw;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

import ru.yandex.base64.Base64Decoder;
import ru.yandex.client.cocaine.worker.http.unistorage.ImmutableUnistorageHttpServiceConfig;
import ru.yandex.function.ByteArrayCopier;
import ru.yandex.mail.so.factors.config.ExtractModulesConfig;
import ru.yandex.mail.so.factors.config.ImmutableExtractModulesConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.tikaite.config.ImmutableTextExtractorConfig;

public class ImmutableTikaiteSrwConfig
    extends ImmutableUnistorageHttpServiceConfig
    implements TikaiteSrwConfig
{
    private final ImmutableTextExtractorConfig textExtractorConfig;
    private final ImmutableExtractModulesConfig extractModulesConfig;
    private final String rsaPublicKey;
    private final PublicKey publicKey;

    public ImmutableTikaiteSrwConfig(final TikaiteSrwConfig config)
        throws ConfigException
    {
        super(config);
        textExtractorConfig =
            new ImmutableTextExtractorConfig(config.textExtractorConfig());
        ExtractModulesConfig extractModulesConfig =
            config.extractModulesConfig();
        if (extractModulesConfig == null) {
            this.extractModulesConfig = null;
        } else {
            this.extractModulesConfig =
                new ImmutableExtractModulesConfig(
                    config.extractModulesConfig());
        }
        rsaPublicKey = RSA_PUBLIC_KEY.validate(config.rsaPublicKey());
        if (rsaPublicKey == null) {
            publicKey = null;
        } else {
            try {
                Base64Decoder decoder = new Base64Decoder();
                decoder.process(rsaPublicKey.toCharArray());
                byte[] bytes = decoder.processWith(ByteArrayCopier.INSTANCE);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                publicKey = keyFactory.generatePublic(keySpec);
            } catch (IOException
                | RuntimeException
                | GeneralSecurityException e)
            {
                throw new ConfigException(
                    "Failed to load public key \"" + rsaPublicKey + '"',
                    e);
            }
        }
    }

    @Override
    public ImmutableTextExtractorConfig textExtractorConfig() {
        return textExtractorConfig;
    }

    @Override
    public ImmutableExtractModulesConfig extractModulesConfig() {
        return extractModulesConfig;
    }

    @Override
    public String rsaPublicKey() {
        return rsaPublicKey;
    }

    public PublicKey publicKey() {
        return publicKey;
    }
}

