package ru.yandex.tikaite.srw;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import ru.yandex.base64.Base64Encoder;
import ru.yandex.http.util.BadRequestException;

public class RsaEncryptionContext implements EncryptionContext {
    private static final int AES_KEY_LENGTH = 16;
    private static final int AES_IV_LENGTH = 16;

    private static final String RSA_CIPHER_PROVIDER =
        "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static final ThreadLocal<SecureRandom> RANDOM =
        ThreadLocal.withInitial(SecureRandom::new);
    private static final ThreadLocal<Base64Encoder> BASE64_ENCODER =
        ThreadLocal.withInitial(Base64Encoder::new);

    private final PublicKey publicKey;
    private final byte[] keyBytes;
    private final byte[] ivBytes;

    public RsaEncryptionContext(final PublicKey publicKey)
        throws BadRequestException
    {
        if (publicKey == null) {
            throw new BadRequestException("Encryption not configured");
        }
        this.publicKey = publicKey;
        SecureRandom random = RANDOM.get();
        keyBytes = new byte[AES_KEY_LENGTH];
        random.nextBytes(keyBytes);
        ivBytes = new byte[AES_IV_LENGTH];
        random.nextBytes(ivBytes);
    }

    @Override
    public void adjustResponseHeaders(final List<Header> headers)
        throws GeneralSecurityException
    {
        Base64Encoder base64Encoder = BASE64_ENCODER.get();
        Cipher cipher = Cipher.getInstance(RSA_CIPHER_PROVIDER);
        cipher.init(Cipher.ENCRYPT_MODE, publicKey);
        base64Encoder.process(cipher.doFinal(keyBytes));
        headers.add(
            new BasicHeader(
                "X-Yandex-Aes-Key-Encrypted",
                base64Encoder.toString()));

        cipher.init(Cipher.ENCRYPT_MODE, publicKey);
        base64Encoder.process(cipher.doFinal(ivBytes));
        headers.add(
            new BasicHeader(
                "X-Yandex-Aes-IV-Encrypted",
                base64Encoder.toString()));
    }

    @Override
    public OutputStream wrapOutputStream(final OutputStream out)
        throws GeneralSecurityException
    {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, key, iv);
        return new BufferedOutputStream(new CipherOutputStream(out, cipher));
    }
}

