package ru.yandex.tikaite.srw;

import ru.yandex.client.cocaine.worker.http.unistorage.UnistorageHttpServiceConfig;
import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.mail.so.factors.config.ExtractModulesConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.tikaite.config.TextExtractorConfig;

public interface TikaiteSrwConfig extends UnistorageHttpServiceConfig {
    ParameterConfig<String> RSA_PUBLIC_KEY = new ParameterConfig<>(
        "rsa.public-key",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
        true);

    TextExtractorConfig textExtractorConfig();

    ExtractModulesConfig extractModulesConfig();

    String rsaPublicKey();
}

