#!/bin/bash
ulimit -c unlimited

export ROOT=${ROOT:-/app}
export SANITIZER_CONFIGS_ROOT=$ROOT
export LIBUNPERSON=$ROOT/libunperson-jniwrapper.so
export HNSW_DSSM=$ROOT/model.dssm

source $ROOT/classpath.sh
$ROOT/jdk/bin/java -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Xgcpolicy:gencon -Xnoclassgc -Xconcurrentbackground2 -Xconcurrentlevel8 -Xgcthreads4 -Xss8M -Xmn256M -Xmx1536M -Xdump:java+console:events=user -Djavax.xml.accessExternalDTD= -Djavax.xml.accessExternalSchema= -Djava.library.path=$ROOT/tikaite_srw -cp $CLASSPATH ru.yandex.tikaite.srw.TikaiteSrw $ROOT/tikaite-srw.conf $@ 2>&1 | tee $ROOT/stdout.log

