#!/bin/bash
ulimit -c unlimited

export ROOT=${ROOT:-/app}
export SANITIZER_CONFIGS_ROOT=$ROOT
export LIBUNPERSON=$ROOT/libunperson-jniwrapper.so
export HNSW_DSSM=$ROOT/model.dssm
export SELENIUM_INSTANCES=1
export OCRAAS_INSTANCES=1
export QUEUE_OCR_WORKERS=true
export OCRAAS_MAX_PROCESS_TIME=0
export LIBOCRAAS=$ROOT/libocraas-jniwrapper-jniwrapper.so
export OCRAAS_CONFIG=$ROOT/ocrdata/ocrdata/yt/ocr.OCRNNLiteEnRu.cfg
export FAST_TEXT_MODEL=$ROOT/fast-text.bin

source $ROOT/classpath.sh

$ROOT/jdk/bin/java -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -XX:ActiveProcessorCount=3 -Xgcpolicy:gencon -Xnoclassgc -Xconcurrentbackground2 -Xconcurrentlevel4 -Xgcthreads3 -Xss8M -Xmn256M -Xmx512M -Xdump:none -Djavax.xml.accessExternalDTD= -Djavax.xml.accessExternalSchema= -Djava.library.path=$ROOT/tikaite_srw -cp $CLASSPATH ru.yandex.tikaite.srw.TikaiteSrw $ROOT/tikaite-ml-srw.conf $@ 2>&1 | tee $ROOT/stdout.log

