package ru.yandex.cokemulator;

import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.parser.config.NullableSectionConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;
import ru.yandex.util.storage.DataExtractorConfig;

public interface CokemulatorConfig extends HttpProxyConfig {
    NullableSectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        STORAGE_CONFIG = new NullableSectionConfig<>(
            "storage",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new,
            null,
            HttpHostConfigDefaults.INSTANCE,
            null);

    SectionConfig<
        JniWrapperConfig,
        ImmutableJniWrapperConfig,
        JniWrapperConfigBuilder>
        JNIWRAPPER_CONFIG = new SectionConfig<>(
            "cokemulator",
            JniWrapperConfigBuilder::new,
            ImmutableJniWrapperConfig::new);

    ParameterConfig<Integer> CONCURRENCY = new ParameterConfig<>(
        "concurrency",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<String> URI_SUFFIX = new ParameterConfig<>(
        "uri-suffix",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> URI_PREFIX = new ParameterConfig<>(
        "uri-prefix",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Integer> COKEMULATOR_PORT = new ParameterConfig<>(
        "cokemulator-port",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<String> APE_CLIENT_ID = new ParameterConfig<>(
        "storage.ape-client-id",
        GenericFunction.identity(),
        NonEmptyValidator.TRIMMED);
    ParameterConfig<String> UNISTORAGE_CLIENT_ID = new ParameterConfig<>(
        "storage.unistorage-client-id",
        GenericFunction.identity(),
        NonEmptyValidator.TRIMMED);

    HttpHostConfig storageConfig();

    HttpHost avaHost();

    int concurrency();

    JniWrapperConfig jniWrapperConfig();

    DataType dataType();

    DataExtractorConfig dataExtractorConfig();

    ContentType contentType();

    String uriSuffix();

    HttpHostConfig mulcagateConfig();

    int cokemulatorPort();

    HttpHostConfig tikaiteConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    String apeClientId();

    String unistorageClientId();

    String uriPrefix();
}

