package ru.yandex.cokemulator;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class CokemulatorConfigBuilder
    extends AbstractCokemulatorConfigBuilder<CokemulatorConfigBuilder>
{
    public CokemulatorConfigBuilder() {
        super(CokemulatorConfigDefaults.INSTANCE);
    }

    public CokemulatorConfigBuilder(final CokemulatorConfig config) {
        super(config);
    }

    public CokemulatorConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, CokemulatorConfigDefaults.INSTANCE);
    }

    public CokemulatorConfigBuilder(
        final IniConfig config,
        final CokemulatorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public CokemulatorConfigBuilder self() {
        return this;
    }

    public ImmutableCokemulatorConfig build() throws ConfigException {
        return new ImmutableCokemulatorConfig(this);
    }
}

