package ru.yandex.cokemulator;

import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigDefaults;
import ru.yandex.util.storage.DataExtractorConfig;
import ru.yandex.util.storage.DataExtractorConfigDefaults;

public class CokemulatorConfigDefaults
    extends HttpProxyConfigDefaults
    implements CokemulatorConfig
{
    public static final CokemulatorConfigDefaults INSTANCE =
        new CokemulatorConfigDefaults();

    protected CokemulatorConfigDefaults() {
    }

    @Override
    public String name() {
        return "Cokemulator";
    }

    @Override
    public HttpHostConfig storageConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public int concurrency() {
        return Integer.MAX_VALUE;
    }

    @Override
    public JniWrapperConfig jniWrapperConfig() {
        return JniWrapperConfigDefaults.INSTANCE;
    }

    @Override
    public DataType dataType() {
        return DataType.RAW;
    }

    @Override
    public DataExtractorConfig dataExtractorConfig() {
        return DataExtractorConfigDefaults.INSTANCE;
    }

    @Override
    public ContentType contentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public String uriSuffix() {
        return null;
    }

    @Override
    public HttpHostConfig mulcagateConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public int cokemulatorPort() {
        return 0;
    }

    @Override
    public HttpHostConfig tikaiteConfig() {
        return null;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public String apeClientId() {
        return null;
    }

    @Override
    public String unistorageClientId() {
        return null;
    }

    @Override
    public String uriPrefix() {
        return null;
    }

    @Override
    public HttpHost avaHost() {
        return null;
    }
}

