package ru.yandex.cokemulator;

import ru.yandex.util.storage.C2CDataExtractor;
import ru.yandex.util.storage.DataExtractor;
import ru.yandex.util.storage.MailTextExtractor;
import ru.yandex.util.storage.RawDataExtractor;

public enum DataType {
    RAW {
        @Override
        public String additionalCgis() {
            return "raw";
        }

        @Override
        public DataExtractor dataExtractor() {
            return RawDataExtractor.INSTANCE;
        }
    },
    MAIL_TEXT {
        @Override
        public String additionalCgis() {
            return RAW.additionalCgis();
        }

        @Override
        public DataExtractor dataExtractor() {
            return MailTextExtractor.INSTANCE;
        }
    },
    C2C {
        @Override
        public String additionalCgis() {
            return null;
        }

        @Override
        public DataExtractor dataExtractor() {
            return C2CDataExtractor.INSTANCE;
        }
    },
    C2SRW {
        @Override
        public String additionalCgis() {
            return null;
        }

        @Override
        public DataExtractor dataExtractor() {
            return C2CDataExtractor.INSTANCE;
        }
    };

    public abstract String additionalCgis();

    public abstract DataExtractor dataExtractor();
}

