package ru.yandex.cokemulator;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.ByteArrayEntityFactory;
import ru.yandex.util.storage.C2CDataExtractor;
import ru.yandex.util.storage.StorageData;

public class GetTextHandler implements HttpRequestHandler {
    private final Cokemulator server;

    public GetTextHandler(final Cokemulator server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        StorageData storageData = server.sendStorageRequest(request, context);
        response.setEntity(
            storageData.processWith(ByteArrayEntityFactory.INSTANCE));
        String metainfo = storageData.metainfo();
        if (metainfo != null) {
            response.addHeader(C2CDataExtractor.METAINFO, metainfo);
        }
    }
}

