package ru.yandex.executor.concurrent;

import java.util.concurrent.locks.Lock;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TasksProvider<T> {
    // Return next task or block indefinitely util task will be available
    // Return null if process was stopped externally and task execution should
    // be terminated
    // This function expected to be called with current thread is holding lock
    @Nullable
    T getTask() throws InterruptedException;

    // Return next task if any available or null if there is no tasks available
    // at the moment
    // This function expected to be called with current thread is holding lock
    @Nullable
    T tryGetTask();

    // Lock object that should be used for synchronization.
    // All getTask() and tryGetTask() invocations will be done under this lock
    @Nonnull
    Lock lock();
}

