#pragma once

#include <string>
#include "options.hpp"

namespace dsn {

struct rcpt
{
    enum status_t
    {
        success,
        failure
    };

    std::string name_;
    std::string remote_answer_;
    int notify_mode_ = dsn::Options::NONE;
    status_t status_ = status_t::failure;
};

class composer
{
public:
    enum type_t
    {
        success,
        failure
    };

    explicit composer(const Options& options);

    void my_domain(const std::string& domain);

    std::pair<bool, std::string> compose(
        type_t t,
        const std::string& id,
        const std::string& orig_id,
        const std::string& sender,
        const std::vector<rcpt>& rcpts) const;

private:
    const Options& options_;
    std::string my_domain_;
};

} // namespace dsn
