/*
 * conf_parser.cpp
 *
 *  Created on: Oct 5, 2011
 *      Author: khanton@yandex-team.ru
 */

#include <vector>
#include <string>
#include <boost/shared_ptr.hpp>
#include <boost/bind.hpp>
#include <boost/throw_exception.hpp>
#include <boost/program_options/errors.hpp>
#include <cctype>
#include <fstream>

#include "conf_parser.hpp"
#include "config_file.hpp"

using namespace std;
using namespace boost;

boost::program_options::parsed_options parse_dsn_config_file(std::istream& _is, const boost::program_options::options_description& _desc,
                                        bool _allow_unregistered)

{
        set<string> allowed_options;

        const vector<boost::shared_ptr<
            boost::program_options::option_description>
            >& options = _desc.options();
        for (unsigned i = 0; i < options.size(); ++i)
        {
            const boost::program_options::option_description& d = *options[i];

            if (d.long_name().empty())
                boost::throw_exception(
                    program_options::error("long name required for config file"));

            allowed_options.insert(d.long_name());
        }

        // Parser return char strings
        program_options::parsed_options result(&_desc);
        copy(dsn_basic_config_file_iterator<char>(
                 _is, allowed_options, _allow_unregistered),
                 dsn_basic_config_file_iterator<char>(),
             back_inserter(result.options));
        // Convert char strings into desired type.
        return program_options::parsed_options(result);
}

boost::program_options::parsed_options parse_dsn_config_file(const char* filename,
                      const boost::program_options::options_description& desc,
                      bool allow_unregistered)
{
        // Parser return char strings
        std::ifstream strm(filename);
        if (!strm)
        {
            boost::throw_exception(boost::program_options::reading_file(filename));
        }
        return parse_dsn_config_file(strm, desc, allow_unregistered);
}


