#include <boost/program_options/config.hpp>

#include <boost/program_options/detail/config_file.hpp>
#include <boost/program_options/errors.hpp>
#include <boost/program_options/detail/convert.hpp>
#include <boost/throw_exception.hpp>

#include <iostream>
#include <fstream>
#include <cassert>

#include "config_file.hpp"

using namespace std;

dsn_config_file_iterator::dsn_config_file_iterator(
        const std::set<std::string>& allowed_options,
        bool allow_unregistered)
    : allowed_options(allowed_options),
      m_allow_unregistered(allow_unregistered)
    {
        for(std::set<std::string>::const_iterator i = allowed_options.begin();
            i != allowed_options.end();
            ++i)
        {
            add_option(i->c_str());
        }
    }

    void
    dsn_config_file_iterator::add_option(const char* name)
    {
        string s(name);
        assert(!s.empty());
        if (*s.rbegin() == '*') {
            s.resize(s.size()-1);
            bool bad_prefixes(false);
            // If 's' is a prefix of one of allowed suffix, then
            // lower_bound will return that element.
            // If some element is prefix of 's', then lower_bound will
            // return the next element.
            set<string>::iterator i = allowed_prefixes.lower_bound(s);
            if (i != allowed_prefixes.end()) {
                if (i->find(s) == 0)
                    bad_prefixes = true;
            }
            if (i != allowed_prefixes.begin()) {
                --i;
                if (s.find(*i) == 0)
                    bad_prefixes = true;
            }
            if (bad_prefixes)
                boost::throw_exception(boost::program_options::error("bad prefixes"));
            allowed_prefixes.insert(s);
        }
    }

    namespace {
        string trim_ws(const string& s)
        {
            string::size_type n, n2;
            n = s.find_first_not_of(" \t\r\n");
            if (n == string::npos)
                return string();
            else {
                n2 = s.find_last_not_of(" \t\r\n");
                return s.substr(n, n2-n+1);
            }
        }
    }


    void dsn_config_file_iterator::get()
    {
        namespace bpo = boost::program_options;
        string s;
        string::size_type n;
        bool found = false;
        bool collect = false;
        std::string collect_end_of_val;
    	std::string collect_value;
    	std::string collect_name;
    	bool collect_unregistered = false;


        while(this->getline(s)) {

        	if (collect)
        	{
        		if (s == collect_end_of_val)
        		{
        			collect = false;
                    found = true;
                    this->value().string_key = collect_name;
                    this->value().value.clear();
                    this->value().value.push_back(collect_value);
                    this->value().unregistered = collect_unregistered;
                    this->value().original_tokens.clear();
                    this->value().original_tokens.push_back(collect_name);
                    this->value().original_tokens.push_back(collect_value);
                    break;
        		}
        		else
        		{
        			collect_value += s + "\r\n";
        			continue;
        		}
        	}

            // strip '#' comments and whitespace
            if ((n = s.find('#')) != string::npos)
                s = s.substr(0, n);
            s = trim_ws(s);

            if (!s.empty()) {
                // Handle section name
                if (*s.begin() == '[' && *s.rbegin() == ']') {
                    m_prefix = s.substr(1, s.size()-2);
                    if (*m_prefix.rbegin() != '.')
                        m_prefix += '.';
                }
                else if ((n = s.find('=')) != string::npos) {

                    string name = m_prefix + trim_ws(s.substr(0, n));
                    string value = trim_ws(s.substr(n+1));

                    bool registered = allowed_option(name);
                    if (!registered && !m_allow_unregistered)
                        boost::throw_exception(bpo::unknown_option(name));

                    if (value.substr(0,2) == "<<")
                    {
                    	collect_end_of_val = trim_ws(value.substr(3));
                    	collect_value = "";
                    	collect_name = name;
                    	collect_unregistered = !registered;

                    	collect = true;
                    	continue;
                    }

                    found = true;
                    this->value().string_key = name;
                    this->value().value.clear();
                    this->value().value.push_back(value);
                    this->value().unregistered = !registered;
                    this->value().original_tokens.clear();
                    this->value().original_tokens.push_back(name);
                    this->value().original_tokens.push_back(value);
                    break;

                } else {
#if BOOST_VERSION < 105000
                    boost::throw_exception(bpo::invalid_syntax(
                                s,
                                bpo::invalid_syntax::unrecognized_line));
#else
                    boost::throw_exception(bpo::invalid_syntax(
                                bpo::invalid_syntax::unrecognized_line,
                                s));
#endif
                }
            }
        }
        if (!found)
            found_eof();
    }


    bool
    dsn_config_file_iterator::allowed_option(const std::string& s) const
    {
        set<string>::const_iterator i = allowed_options.find(s);
        if (i != allowed_options.end())
            return true;
        // If s is "pa" where "p" is allowed prefix then
        // lower_bound should find the element after "p".
        // This depends on 'allowed_prefixes' invariant.
        i = allowed_prefixes.lower_bound(s);
        if (i != allowed_prefixes.begin() && s.find(*--i) == 0)
            return true;
        return false;
    }
