
#pragma once
#include <iosfwd>
#include <string>
#include <set>

#include <boost/noncopyable.hpp>
#include <boost/program_options/config.hpp>
#include <boost/program_options/option.hpp>
#include <boost/program_options/eof_iterator.hpp>

#include <boost/detail/workaround.hpp>

#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/shared_ptr.hpp>

class dsn_config_file_iterator
        : public boost::eof_iterator<dsn_config_file_iterator, boost::program_options::option>
{
    public:
        dsn_config_file_iterator() { found_eof(); }
        dsn_config_file_iterator(
            const std::set<std::string>& allowed_options,
            bool allow_unregistered = false);

        virtual ~dsn_config_file_iterator() {}

    public: // Method required by eof_iterator
        
        void get();
        
    protected:

        virtual bool getline(std::string&) { return false; }
        
    private:
    
        void add_option(const char* name);

        bool allowed_option(const std::string& s) const; 

        std::set<std::string> allowed_options;
        std::set<std::string> allowed_prefixes;
        std::string m_prefix;
        bool m_allow_unregistered;
    };

template<class charT>
class dsn_basic_config_file_iterator : public dsn_config_file_iterator {
public:
        dsn_basic_config_file_iterator()
        {
            found_eof();
        }

        dsn_basic_config_file_iterator(std::basic_istream<charT>& is, 
                                   const std::set<std::string>& allowed_options,
                                   bool allow_unregistered = false); 

    private:

        bool getline(std::string&);

    private:
        boost::shared_ptr<std::basic_istream<charT> > is;
    };
    
    typedef dsn_basic_config_file_iterator<char> config_file_iterator;
    typedef dsn_basic_config_file_iterator<wchar_t> wconfig_file_iterator;


    struct null_deleter
    {
        void operator()(void const *) const {}
    };


    template<class charT>
    dsn_basic_config_file_iterator<charT>::
    dsn_basic_config_file_iterator(std::basic_istream<charT>& is, 
                               const std::set<std::string>& allowed_options,
                               bool allow_unregistered)
    : dsn_config_file_iterator(allowed_options, allow_unregistered)
    {
        this->is.reset(&is, null_deleter());                 
        get();
    }

    // Specializing this function for wchar_t causes problems on
    // borland and vc7, as well as on metrowerks. On the first two
    // I don't know a workaround, so make use of 'to_internal' to
    // avoid specialization.
    template<class charT>
    bool
    dsn_basic_config_file_iterator<charT>::getline(std::string& s)
    {
        std::basic_string<charT> in;
        if (std::getline(*is, in)) {
            s = boost::program_options::to_internal(in);
            return true;
        } else {
            return false;
        }
    }
