/*
 * exp_tokens.cpp
 *
 *  Created on: Oct 6, 2011
 *      Author: khanton@yandex-team.ru
 */

#include "exp_tokens.hpp"

std::string exp_tokens::expand_tokens(const std::string &_src, const exp_tokens::token_list_t &_tokens)
{
	std::string buf;
	std::string::size_type pos = 0;
	std::string::size_type found;

    while ((found = _src.find('$', pos)) != std::string::npos)
	{
        // handle "$$" as escaped "$"
        if (found + 1 < _src.length() && _src[found + 1] == '$')
        {
            buf += _src.substr(pos, found - pos);
            buf += '$';

            pos = found + 2;

            continue;
        }

        std::string::size_type end = _src.find_first_of(" \t\r\n.,?!:;", found);
		std::string name;

		if (end == std::string::npos)
			name = _src.substr(found+1);
		else
			name = _src.substr(found + 1, end - found - 1);

		buf += _src.substr(pos, found - pos);

		exp_tokens::token_list_t::const_iterator mit = _tokens.find(name);

		if (mit == _tokens.end())
			buf += '$' + name;
		else
			buf += mit->second;

		pos = found + name.size() + 1;
	}

	buf += _src.substr(pos);

	return buf;
}
