#pragma once

#include <ymod_smtpclient/smtp_point.h>
#include <yplatform/ptree.h>
#include <string>
#include <vector>

namespace dsn {

struct Template
{
    std::vector<std::string> domains;
    std::string charset;
    std::string subject;
    std::string body;
};

int parse_mode(const std::string &mode);

struct Options
{

    void init(const yplatform::ptree& pt);

    enum
    {
        NONE = 0, NEVER = 0x1, SUCCESS = 0x2, FAILURE = 0x4, DELAY = 0x8
    };

    std::string origin;
    std::vector<Template> failureTemplates;
    std::vector<Template> successTemplates;
};

}   // namespace dsn
