#include "dsn_composer_test.h"

using TSuccessDsnComposer = TDsnComposer<dsn::composer::success>;
using TFailureDsnComposer = TDsnComposer<dsn::composer::failure>;

const dsn::rcpt RCPT_SUCCESS{
    "success@yandex.ru",
    "250 2.0.0 Ok; SRu8EiJV1Q-kRWNdemj 170010885933236994 770",
    dsn::Options::SUCCESS,
    dsn::rcpt::success
};

const dsn::rcpt RCPT_FAILURE{
    "failure@yandex.ru",
    "5.7.1 Policy rejection on the target address",
    dsn::Options::FAILURE,
    dsn::rcpt::failure
};

TEST_F(TSuccessDsnComposer, ReadOptions) {
    ASSERT_EQ(Options.origin, "mailer-daemon@yandex.ru");
    ASSERT_EQ(Options.failureTemplates.size(), 2);
    ASSERT_EQ(Options.successTemplates.size(), 2);

    for (const auto& tmpl : Options.failureTemplates) {
        ASSERT_FALSE(tmpl.body.empty());
        ASSERT_FALSE(tmpl.charset.empty());
        ASSERT_FALSE(tmpl.subject.empty());
        ASSERT_FALSE(tmpl.domains.empty());
    }

    for (const auto& tmpl : Options.successTemplates) {
        ASSERT_FALSE(tmpl.body.empty());
        ASSERT_FALSE(tmpl.charset.empty());
        ASSERT_FALSE(tmpl.subject.empty());
        ASSERT_FALSE(tmpl.domains.empty());
    }
}

TEST_F(TSuccessDsnComposer, SuccessRcptSuccessfulCompose) {
    auto rcpt = RCPT_SUCCESS;
    rcpt.notify_mode_ = dsn::Options::SUCCESS;
    auto [success, msg] = Compose({rcpt});
    ASSERT_TRUE(success);
    ASSERT_FALSE(msg.empty());
}

TEST_F(TSuccessDsnComposer, SuccessRcptFailedCompose) {
    auto rcpt = RCPT_SUCCESS;
    for (auto notifyMode : {dsn::Options::NONE,
                            dsn::Options::NEVER,
                            dsn::Options::FAILURE,
                            dsn::Options::DELAY})
    {
        rcpt.notify_mode_ = notifyMode;
        auto [success, msg] = Compose({rcpt});
        ASSERT_FALSE(success);
        ASSERT_TRUE(msg.empty());
    }
}

TEST_F(TSuccessDsnComposer, FailureRcptFailedCompose) {
    auto rcpt = RCPT_FAILURE;
    for (auto notifyMode : {dsn::Options::SUCCESS,
                            dsn::Options::NONE,
                            dsn::Options::NEVER,
                            dsn::Options::FAILURE,
                            dsn::Options::DELAY})
    {
        rcpt.notify_mode_ = notifyMode;
        auto [success, msg] = Compose({rcpt});
        ASSERT_FALSE(success);
        ASSERT_TRUE(msg.empty());
    }
}

TEST_F(TFailureDsnComposer, FailureRcptSuccessfulCompose) {
    auto rcpt = RCPT_FAILURE;
    for (auto notifyMode : {dsn::Options::NONE,
                            dsn::Options::FAILURE})
    {
        rcpt.notify_mode_ = notifyMode;
        auto [success, msg] = Compose({rcpt});
        ASSERT_TRUE(success);
        ASSERT_FALSE(msg.empty());
    }
}

TEST_F(TFailureDsnComposer, FailureRcptFailedCompose) {
    auto rcpt = RCPT_FAILURE;
    for (auto notifyMode : {dsn::Options::SUCCESS,
                            dsn::Options::NEVER,
                            dsn::Options::DELAY})
    {
        rcpt.notify_mode_ = notifyMode;
        auto [success, msg] = Compose({rcpt});
        ASSERT_FALSE(success);
        ASSERT_TRUE(msg.empty());
    }
}

TEST_F(TFailureDsnComposer, SuccessfulRcptFailedCompose) {
    auto rcpt = RCPT_SUCCESS;
    for (auto notifyMode : {dsn::Options::SUCCESS,
                            dsn::Options::NONE,
                            dsn::Options::NEVER,
                            dsn::Options::FAILURE,
                            dsn::Options::DELAY})
    {
        rcpt.notify_mode_ = notifyMode;
        auto [success, msg] = Compose({rcpt});
        ASSERT_FALSE(success);
        ASSERT_TRUE(msg.empty());
    }
}

TEST_F(TSuccessDsnComposer, MixedRcpt) {
    auto [success, msg] = Compose({RCPT_SUCCESS, RCPT_FAILURE});
    ASSERT_TRUE(success);
    ASSERT_TRUE(msg.find("Final-Recipient: rfc822; " + RCPT_SUCCESS.name_ + "\r\n") != std::string::npos);
    ASSERT_TRUE(msg.find("Final-Recipient: rfc822; " + RCPT_FAILURE.name_ + "\r\n") == std::string::npos);
}
