package ru.yandex.parser.email;

import org.apache.james.mime4j.util.ByteArrayBuffer;

import ru.yandex.function.Processor;

public class ByteArrayBufferFactory
    implements Processor<byte[], ByteArrayBuffer, RuntimeException>
{
    public static final ByteArrayBufferFactory INSTANCE =
        new ByteArrayBufferFactory();

    private static final byte[] EMPTY_BUF = new byte[0];

    protected ByteArrayBufferFactory() {
    }

    @Override
    public ByteArrayBuffer process(final byte[] buf) {
        return new ByteArrayBuffer(buf, true);
    }

    @Override
    public ByteArrayBuffer process(
        final byte[] buf,
        final int off,
        final int len)
    {
        ByteArrayBuffer babuf;
        if (off == 0) {
            babuf = new ByteArrayBuffer(buf, len, true);
        } else {
            babuf = new ByteArrayBuffer(EMPTY_BUF, true);
            babuf.append(buf, off, len);
        }
        return babuf;
    }
}

