package ru.yandex.parser.email.types;

import java.util.Set;
import java.util.TreeSet;

public class MessageFlags {
    private static final long MESSAGE_TYPE_FLAGS = 17;
    private static final long MESSAGE_TYPE_MASK = 63;
    private static final long MESSAGE_TYPE_BITS = 6;
    private static final long ATTACHMENTS_FLAG = 1;
    private static final long DRAFT_FLAG = 64;

    private final Set<Integer> types = new TreeSet<>();
    private final long flags;

    // CSOFF: FinalParameters
    public MessageFlags(long flags) {
        this.flags = flags;
        flags >>>= MESSAGE_TYPE_FLAGS;
        while (flags != 0L) {
            int type = (int) (flags & MESSAGE_TYPE_MASK);
            if (type != 0) {
                types.add(type);
            }
            flags >>>= MESSAGE_TYPE_BITS;
        }
    }
    // CSON: FinalParameters

    public Set<Integer> types() {
        return types;
    }

    public boolean hasAttachments() {
        return (flags & ATTACHMENTS_FLAG) != 0;
    }

    public boolean isDraft() {
        return (flags & DRAFT_FLAG) != 0;
    }
}

