package ru.yandex.parser.email.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

// see https://wiki.yandex-team.ru/pochta/types/status/
public enum MessageType {
    // mail types
    DELIVERY(1, MTypePart.MAIL),
    REGISTRATION(2, MTypePart.MAIL),
    SOCIAL(3, MTypePart.MAIL),
    PEOPLE(4, MTypePart.MAIL),
    ETICKET(5, MTypePart.MAIL),
    ESHOP(6, MTypePart.MAIL),
    NOTIFICATION(7, MTypePart.MAIL),
    BOUNCE(8, MTypePart.MAIL),
    GREETING(12, MTypePart.MAIL),
    NEWS(13, MTypePart.MAIL),
    PERSONALNEWS(22, MTypePart.MAIL),
    SCHEMA(27, MTypePart.MAIL),
    CANCEL(28, MTypePart.MAIL),
    HOTEL(35, MTypePart.MAIL),
    YAMONEY(36, MTypePart.MAIL),
    LIVEMAIL(38, MTypePart.MAIL),
    INVITE(42, MTypePart.MAIL),
    PHISHING(40, MTypePart.MAIL),
    TRANSACT(64, MTypePart.MAIL),
    PERSONAL(65, MTypePart.MAIL),
    PROMO(66, MTypePart.MAIL),
    TRIGGER(67, MTypePart.MAIL),
    REVIEW(68, MTypePart.MAIL),
    MESSAGE(69, MTypePart.MAIL),
    BILL(70, MTypePart.MAIL),
    LOSTCART(71, MTypePart.MAIL),
    SMARTREPLY(72, MTypePart.MAIL),
    SOFP(73, MTypePart.MAIL),
    CORRESPOND(76, MTypePart.MAIL),

    // sender types
    S_GROUPONSITE(14, MTypePart.SENDER),
    S_DATINGSITE(15, MTypePart.SENDER),
    S_AVIAETICKET(16, MTypePart.SENDER),
    S_BANK(17, MTypePart.SENDER),
    S_SOCIAL(18, MTypePart.SENDER),
    S_TRAVEL(19, MTypePart.SENDER),
    S_ZDTICKET(20, MTypePart.SENDER),
    S_REALTY(21, MTypePart.SENDER),
    S_ESHOP(23, MTypePart.SENDER),
    S_COMPANY(24, MTypePart.SENDER),
    S_JOB(25, MTypePart.SENDER),
    S_GAME(26, MTypePart.SENDER),
    S_TECH(29, MTypePart.SENDER),
    S_MEDIA(30, MTypePart.SENDER),
    S_ADVERT(31, MTypePart.SENDER),
    S_PROVIDER(32, MTypePart.SENDER),
    S_FORUM(33, MTypePart.SENDER),
    S_MOBILE(34, MTypePart.SENDER),
    S_TRAINING(37, MTypePart.SENDER),
    S_SENDER(39, MTypePart.SENDER),
    S_TRACKER(41, MTypePart.SENDER),
    S_TAXI(43, MTypePart.SENDER),
    S_DELIVERY(44, MTypePart.SENDER),
    S_STATE(45, MTypePart.SENDER),
    S_EVENT(48, MTypePart.SENDER),
    S_YANDEXPAY(74, MTypePart.SENDER),

    // is_mixed fields
    S_NEWS(47, MTypePart.MIXED),
    FIRSTMAIL(46, MTypePart.MIXED),
    EDOC(49, MTypePart.MIXED),
    TRUST_1(51, MTypePart.MIXED),
    TRUST_2(52, MTypePart.MIXED),
    TRUST_3(53, MTypePart.MIXED),
    TRUST_4(54, MTypePart.MIXED),
    TRUST_5(55, MTypePart.MIXED),
    TRUST_6(56, MTypePart.MIXED),
    S_SEO(57, MTypePart.MIXED),
    S_INSURANCE(58, MTypePart.MIXED),
    REMINDER(59, MTypePart.MIXED),
    BOARDINGPASS(60, MTypePart.MIXED),
    TRACKERTASK(61, MTypePart.MIXED),
    DISCOUNT(62, MTypePart.MIXED),
    REMIND_TIC(63, MTypePart.MIXED),

    // tab types
    T_NEWS(100, MTypePart.TAB),
    T_SOCIAL(101, MTypePart.TAB),
    T_NOTIFICATION(102, MTypePart.TAB),
    T_PEOPLE(103, MTypePart.TAB),

    // SO resolution explanations, see SODEV-2181
    PF_HAM(77, MTypePart.SO_RESOLUTION),
    PF_SPAM(78, MTypePart.SO_RESOLUTION),
    SPF_FAIL(79, MTypePart.SO_RESOLUTION),
    DKIM_FAIL(80, MTypePart.SO_RESOLUTION),
    DMARC_FAIL(81, MTypePart.SO_RESOLUTION),
    IP_RBL(82, MTypePart.SO_RESOLUTION),
    URL_RBL(83, MTypePart.SO_RESOLUTION),
    DNS_FAIL(84, MTypePart.SO_RESOLUTION),
    RFC_FAIL(85, MTypePart.SO_RESOLUTION);

    public static final List<MessageType> MAIL_TYPES =
        Collections.unmodifiableList(
            Arrays.stream(MessageType.values())
                .filter(
                    m -> m.part() == MTypePart.MAIL
                        || m.part() == MTypePart.TAB).collect(
                            Collectors.toList()));

    private final int typeNumber;
    private final String typeName;
    private final MTypePart part;

    MessageType(final int typeNumber, final MTypePart part) {
        this.typeNumber = typeNumber;
        this.part = part;
        typeName = name().toLowerCase(Locale.ROOT);
    }

    public int typeNumber() {
        return typeNumber;
    }

    public MTypePart part() {
        return part;
    }

    @Override
    public String toString() {
        return typeName;
    }
}

