package ru.yandex.parser.email.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import ru.yandex.function.GenericFunction;

public enum MessageTypeToString
    implements GenericFunction<String, MessageType, RuntimeException>
{
    INSTANCE;

    @SuppressWarnings("ImmutableEnumChecker")
    private final String[] types;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, MessageType> stringToType;

    MessageTypeToString() {
        MessageType[] messageTypes = MessageType.values();
        int max = 0;
        for (MessageType messageType: messageTypes) {
            if (messageType.typeNumber() > max) {
                max = messageType.typeNumber();
            }
        }
        types = new String[max + 1];
        stringToType = new HashMap<>(messageTypes.length << 1);
        for (MessageType messageType: messageTypes) {
            types[messageType.typeNumber()] = messageType.toString();
            stringToType.put(messageType.toString(), messageType);
        }
    }

    public String lookup(final int type) {
        if (type < types.length) {
            return types[type];
        } else {
            return null;
        }
    }

    public String joinCodes(
        final Collection<MessageType> types,
        final String delimiter)
    {
        if (types.isEmpty()) {
            return "";
        }

        StringBuilder sb =
            new StringBuilder((2 + delimiter.length()) * types.size());
        for (MessageType type: types) {
            sb.append(type.typeNumber());
            sb.append(delimiter);
        }

        sb.setLength(sb.length() - 1);
        return new String(sb);
    }

    @Override
    public MessageType apply(final String type) {
        return Objects.requireNonNull(stringToType.get(type));
    }
}

