package ru.yandex.geocoder;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractGeocoderConfigBuilder
    <T extends AbstractGeocoderConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements GeocoderConfig
{
    private int results;
    private String origin;

    protected AbstractGeocoderConfigBuilder(final GeocoderConfig config) {
        super(config);
        this.results = config.results();
        this.origin = config.origin();
    }

    protected AbstractGeocoderConfigBuilder(
        final IniConfig config,
        final GeocoderConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.results = config.get(
            "results",
            defaults.results(),
            PositiveIntegerValidator.INSTANCE);
        this.origin = config.get(
            "origin",
            defaults.origin(),
            NonEmptyValidator.INSTANCE);
    }

    @Override
    public int results() {
        return results;
    }

    public T results(final int results) {
        this.results = results;
        return self();
    }

    @Override
    public String origin() {
        return origin;
    }

    public T origin(final String origin) {
        this.origin = origin;
        return self();
    }
}
