package ru.yandex.geocoder;

public enum Coordinates {
    Latitude(-90.0, +90.0),
    Longitude(-180.0, +180.0);

    private final double min;
    private final double max;

    Coordinates(final double min, final double max) {
        this.min = min;
        this.max = max;
    }

    private double normalize(final double value) {
        double normValue = value;
        if (normValue < min || normValue > max) {
            normValue %= max - min;
            if (normValue < min) {
                normValue += max - min;
            }
            if (normValue > max) {
                normValue -= max - min;
            }
        }
        return normValue;
    }

    public double[] split(final double lower, final double upper) {
        double normLower = normalize(lower);
        double normUpper = normalize(upper);
        if (normLower > normUpper) {
            return new double[]{normLower, max, min, normUpper};
        } else {
            return new double[]{normLower, normUpper};
        }
    }
}
