package ru.yandex.geocoder;

import java.util.concurrent.Future;
import java.util.function.Supplier;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;

public class GeocoderClient extends AbstractAsyncClient<GeocoderClient> {
    private final HttpHost host;

    public GeocoderClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableGeocoderConfig geocoderConfig)
    {
        super(reactor, geocoderConfig);
        host = geocoderConfig.host();
    }

    public GeocoderClient(
        final CloseableHttpAsyncClient client,
        final GeocoderClient sample)
    {
        super(client, sample);
        this.host = sample.host;
    }

    @Override
    protected GeocoderClient adjust(final CloseableHttpAsyncClient client) {
        return new GeocoderClient(client, this);
    }

    public Future<GeocoderResult> execute(
        final GeocoderRequest request,
        final Supplier<? extends HttpClientContext> contextGenerator,
        final FutureCallback<? super GeocoderResult> callback)
        throws BadRequestException
    {
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(request.getQuery());
        for (Header header: request.getHeaders()) {
            producerGenerator.addHeader(header);
        }
        return execute(
            host,
            producerGenerator,
            GeocoderConsumerFactory.OK,
            contextGenerator,
            callback);
    }

    public Future<GeocoderResult> execute(final GeocoderRequest request)
        throws BadRequestException
    {
        return execute(
            request,
            httpClientContextGenerator(),
            EmptyFutureCallback.INSTANCE);
    }
}

