package ru.yandex.geocoder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class GeocoderConfigBuilder
    extends AbstractGeocoderConfigBuilder<GeocoderConfigBuilder>
{
    public GeocoderConfigBuilder() {
        super(GeocoderConfigDefaults.INSTANCE);
    }

    public GeocoderConfigBuilder(final GeocoderConfig config) {
        super(config);
    }

    public GeocoderConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, GeocoderConfigDefaults.INSTANCE);
    }

    public GeocoderConfigBuilder(
        final IniConfig config,
        final GeocoderConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public GeocoderConfigBuilder self() {
        return this;
    }

    public ImmutableGeocoderConfig build() throws ConfigException {
        return new ImmutableGeocoderConfig(this);
    }
}

