package ru.yandex.geocoder;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class GeocoderConsumerFactory
    implements HttpAsyncResponseConsumerFactory<GeocoderResult>
{
    public static final GeocoderConsumerFactory INSTANCE =
        new GeocoderConsumerFactory();
    public static final HttpAsyncResponseConsumerFactory<GeocoderResult> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected GeocoderConsumerFactory() {
    }

    @Override
    public HttpAsyncResponseConsumer<GeocoderResult> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new GeocoderConsumer();
    }
}

