package ru.yandex.geocoder;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class GeocoderRequest {
    private ImmutableGeocoderConfig geocoderConfig;
    private List<Header> headers = new ArrayList<>();
    private String text;
    private String ll;

    public GeocoderRequest(final ImmutableGeocoderConfig geocoderConfig) {
        this.geocoderConfig = geocoderConfig;
    }

    public void addHeader(final String name, final String value) {
        addHeader(new BasicHeader(name, value));
    }

    public void addHeader(final Header header) {
        headers.add(header);
    }

    public List<Header> getHeaders() {
        return headers;
    }

    public void setText(final String text) {
        this.text = text;
    }

    public void setLl(final String ll) {
        this.ll = ll;
    }

    public String getQuery() throws BadRequestException {
        QueryConstructor query =
            new QueryConstructor("/yandsearch?lang=ru_RU&ms=pb");
        query.append("results", geocoderConfig.results());
        query.append("origin", geocoderConfig.origin());
        if (text != null) {
            query.append("text", '"' + text.replace('"', ' ').trim() + '"');
        } else if (ll != null) {
            query.append("ll", ll);
        } else {
            throw new BadRequestException("Empty text param");
        }
        return query.toString();
    }
}
