package ru.yandex.geocoder;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableGeocoderConfig
    extends ImmutableHttpHostConfig
    implements GeocoderConfig
{
    private final int results;
    private final String origin;

    public ImmutableGeocoderConfig(final GeocoderConfig config)
        throws ConfigException
    {
        super(config);
        this.results = config.results();
        this.origin = config.origin();
        if (origin == null || origin.isEmpty()) {
            throw new ConfigException("Origin is not set");
        }
    }

    @Override
    public int results() {
        return results;
    }

    @Override
    public String origin() {
        return origin;
    }
}

