package ru.yandex.mail.hackathon;

import java.util.Optional;

public interface CalendarFacade {
    /**
     * Определяет, есть ли у пользователя в календаре список с таким  названием.
     * @param uid Пользователь
     * @param title Название списка
     * @return Optional.empty(), если список не найден, в противном случае externalId списка, по которому
     * впоследствии можно будет добавить в него новый пункт
     */
    Optional<String> getTodoList(long uid, String title);

    /**
     * Создает новый список в случае необходимости
     * @param uid Пользователь
     * @param title название списка
     * @return external-id списка.
     */
    String createTodoList(long uid, String title);

    /**
     * Создает новый элемент в списке.
     * @param uid Пользователь
     * @param listExternalId external-id списка, который Алиса либо найдет, либо создаст
     * @param title Название покупки
     * @return Идентификатор нового элемента в базе.
     */
    long createTodoItem(long uid, String listExternalId, String title);
}
