package ru.yandex.mail.hackathon.todolistmodifier;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class TodoListModifyState {
    private static final BenderParserSerializer<TodoListModifyState> benderParserSerializer =
            BenderParserSerializer.cons(
                    ClassX.wrap(TodoListModifyState.class),
                    BenderConfiguration.defaultConfiguration()
            );

    static final String UNKNOWN_INPUT_RESPONSE =
            "Я вас не поняла. Попробуйте другую фразу. "
                    + "Вы можете сказать: "
                    + "\"Алиса, создай список покупок\""
                    + " или "
                    + "\"Алиса, добавь в список покупок туалетную бумагу\"";

    public TodoListModifyStatus status;

    public Option<String> listName;

    public Option<String> listExternalId;

    public ListF<String> items;

    public TodoListModifyProcessingResult processingResult;

    public TodoListModifyState() {
        this(TodoListModifyStatus.START, Option.empty(), Option.empty(), Cf.list(), false);
    }

    public TodoListModifyState(TodoListModifyStatus status, Option<String> listName, Option<String> listExternalId, ListF<String> items, boolean failed) {
        this.status = status;
        this.listName = listName;
        this.listExternalId = listExternalId;
        this.items = items;
        this.processingResult = processingResult;
    }

    public static TodoListModifyState parseJson(String json) {
        return benderParserSerializer.getParser().parseJson(json);
    }

    public void addItem(String name) {
        items = items.plus(name);
    }

    private String getLastItem() {
        return items.last();
    }

    public String getResponseToUser() {
        if (processingResult == TodoListModifyProcessingResult.ERROR) {
            // TODO: добавить возможные варианты овета на данном этапе
            return "Что-то пошло не так";
        } else if (processingResult == TodoListModifyProcessingResult.UNKNOWN_INPUT) {
            return UNKNOWN_INPUT_RESPONSE;
        }

        switch (status) {
            case ITEMS_ADDED:
                return "Я добавила " + getLastItem() + " в список " + getListName();

            case LIST_IS_MISSING_WHEN_ADDING_ITEM:
                return "Я не нашла список " + getListName() + ". Создать?";

            case LIST_IS_MISSING_TERMINAL:
                return "Список " + getListName() + " не найден";

            case ITEM_IS_MISSING_TERMINAL:
                return "Я не нашла " + getLastItem() + " в списке " + getListName();

            case LIST_ALREADY_EXISTS:
                return "У вас уже есть список " + getListName();

            case LIST_CREATED:
                return "Я создала список " + getListName();

            case SILENT_OK:
                return null;
        }

        // TODO: добавить возможные варианты овета на данном этапе
        return "Не могу обработать запрос";
    }

    public String getListName() {
        return listName.get();
    }

    public void setListName(String listName) {
        this.listName = Option.of(listName);
    }

    public String getListExternalId() {
        return listExternalId.get();
    }

    public void setListExternalId(String listExternalId) {
        this.listExternalId = Option.of(listExternalId);
    }

    public String toJsonString() {
        return !status.terminal
                ? new String(benderParserSerializer.getSerializer().serializeJson(this))
                : null;
    }
}
