package ru.yandex.mail.hackathon.userrequest;

import java.util.List;
import java.util.Optional;

public class UserRequest {

    private final Intent intent;

    private final Optional<String> listName;

    private final List<String> itemNames;

    public UserRequest(Intent intent, Optional<String> listName, List<String> itemNames) {
        this.intent = intent;
        this.listName = listName;
        this.itemNames = itemNames;
    }

    public Intent getIntent() {
        return intent;
    }

    public Optional<String> getListName() {
        return listName;
    }

    public List<String> getItemNames() {
        return itemNames;
    }

    public enum Intent {
        ADD_ITEMS_TO_LIST(Optional.of("в"), 4, true, true, true),
        REMOVE_ITEM_FROM_LIST(Optional.of("из"), 4, true, true, true),
        CREATE_LIST(Optional.empty(), 2, true, true, false),
        SEND_LIST(Optional.empty(), 3, true, true, false),
        CONFIRM(Optional.empty(), 0, false, false, false),
        DECLINE(Optional.empty(), 0, false, false, false);

        private final Optional<String> preposition;

        private final int minTokensCountAfter;

        public final boolean isInitial;

        public final boolean hasListName;

        public final boolean hasListItem;

        Intent(Optional<String> preposition, int minTokensCountAfter, boolean isInitial, boolean hasListName, boolean hasListItem) {
            this.preposition = preposition;
            this.minTokensCountAfter = minTokensCountAfter;
            this.isInitial = isInitial;
            this.hasListName = hasListName;
            this.hasListItem = hasListItem;
        }

        public Optional<String> getPreposition() {
            return preposition;
        }

        public int getMinTokensCountAfter() {
            return minTokensCountAfter;
        }
    }

}
