package ru.yandex.mail.hackathon.userrequest;

import org.junit.Assert;
import org.junit.Test;

public class UserRequestParserTest {

    @Test
    public void addTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("Алиса, добавь в список покупок туалетную бумагу");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.ADD_ITEMS_TO_LIST, request.getIntent());
        Assert.assertTrue(request.getListName().map("покупок"::equals).orElse(Boolean.FALSE));
        Assert.assertFalse(request.getItemNames().isEmpty());
        Assert.assertEquals(1, request.getItemNames().size());
        Assert.assertEquals("туалетную бумагу", request.getItemNames().get(0));
    }

    @Test
    public void removeTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("Алиса, убери из списка покупок туалетную бумагу");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.REMOVE_ITEM_FROM_LIST, request.getIntent());
        Assert.assertTrue(request.getListName().map("покупок"::equals).orElse(Boolean.FALSE));
        Assert.assertFalse(request.getItemNames().isEmpty());
        Assert.assertEquals(1, request.getItemNames().size());
        Assert.assertEquals("туалетную бумагу", request.getItemNames().get(0));
    }

    @Test
    public void createListTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("Алиса, создай список покупок");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.CREATE_LIST, request.getIntent());
        Assert.assertTrue(request.getListName().map("покупок"::equals).orElse(Boolean.FALSE));
        Assert.assertTrue(request.getItemNames().isEmpty());
    }

    @Test
    public void sendListTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("Алиса, отправь список покупок Антону");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.SEND_LIST, request.getIntent());
        Assert.assertTrue(request.getListName().map("покупок"::equals).orElse(Boolean.FALSE));
        Assert.assertFalse(request.getItemNames().isEmpty());
        Assert.assertEquals(1, request.getItemNames().size());
        Assert.assertEquals("антон", request.getItemNames().get(0));
    }

    @Test
    public void confirmTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("да");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.CONFIRM, request.getIntent());
    }

    @Test
    public void declineTest() {
        UserRequest request = new UserRequestParser().parseUserRequest("нет");
        Assert.assertNotNull(request);
        Assert.assertEquals(UserRequest.Intent.DECLINE, request.getIntent());
    }

}
