#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

XMX=1024
MEM_ARGS="-Xmx${XMX}M -Xms256M -Xmaxf0.2 -Xminf0.1 -Xmine32M -Xmaxe64M -Xloa -Xloainitial0.2"
GC_ARGS="-Xgcpolicy:gencon -verbose:gc -Xgcthreads8 -Xconcurrentbackground2 -Xconcurrentlevel4 -Xgc:concurrentMark -Xgc:concurrentScavengeBackground=1 -Xgc:concurrentScavenge -XX:IdleTuningGcOnIdle -XX:IdleTuningMinIdleWaitTime=1 -Xgc:maxScavengeBeforeGlobal=20 -Xaggressive -Xgc:minContractPercent=2 -Xgc:maxContractPercent=5 -Xverbosegclog:/dev/shm/gc#.log,5,2000"
HACKATHON_ARGS="ru.yandex.mail.hackathon.Hackathon hackathon.conf"
LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $MEM_ARGS $GC_ARGS \
    -Djava.library.path=hackathon \
    -cp $CLASSPATH $HACKATHON_ARGS
