package ru.yandex.mail.hackathon;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.hackathon.config.ImmutableHackathonConfig;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.result.SearchResult;

public class GetEmailFromName {
    private final ProxySession session;

    public GetEmailFromName(
        final ProxySession session,
        final AsyncClient client,
        final ImmutableHackathonConfig config,
        final String uid,
        final String nameToFind,
        final FutureCallback<Object> nextHandler)
    {
        this.session = session;

        final BasicAsyncRequestProducerGenerator request =
            new BasicAsyncRequestProducerGenerator(
                    getRequestString(uid, nameToFind));
        ParseNamesCallback callback = new ParseNamesCallback(
            session,
            nextHandler);

        client.execute(
            config.msearchProxyConfig().host(),
            request,
            SearchResultConsumerFactory.OK,
            session.listener().
                createContextGeneratorFor(client),
            callback);
    }

    private String getRequestString(
            final String uid,
            final String nameToFind)
    {
        String requestString = "";
        try {
            QueryConstructor query = new QueryConstructor(
                "/sequential/search?IO_PRIO=100");
            query.append("prefix", uid);
            query.append("service", "change_log");
            query.append("json-type", "dollar");
            query.append("get", "hdr_from_normalized");
            query.append("text=hdr_from_normalized:*@yandex.ru"
                + "+AND+hdr_from:" + nameToFind);
            requestString = query.toString();
        } catch (BadRequestException e) {
            session.logger().info("NameToEmail, error in getRequestString");
            e.printStackTrace();
        }
        session.logger().info("NameToEmail, requestString = " + requestString);
        return requestString;
    }

    private static class ParseNamesCallback
        extends AbstractProxySessionCallback<SearchResult>
    {
        private FutureCallback<Object> nextHandler;

        ParseNamesCallback(
            final ProxySession session,
            final FutureCallback<Object> nextHandler)
        {
            super(session);
            this.nextHandler = nextHandler;
        }

        @Override
        public void completed(final SearchResult result) {
            session.logger().info("ParseNamesCallback completed, got some result");
            String email = null;
            if (result.hitsArray().size() > 0) {
                email = result.hitsArray().get(0).attrs().get("hdr_from_normalized");
            }
            session.logger().info("ParseNamesCallback, result = <" + email + '>');
            nextHandler.completed(email);
        }

        @Override
        public void failed(final Exception e) {
            session.logger().info("ParseNamesCallback failed");
            nextHandler.completed(null);
        }

        @Override
        public void cancelled() {
            session.logger().info("ParseNamesCallback cancelled");
            nextHandler.completed(null);
        }
    }
}
